<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

// Get form data
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validate required fields
if (!isset($data['name']) || !isset($data['email']) || !isset($data['message'])) {
    http_response_code(400);
    echo json_encode(['error' => 'جميع الحقول مطلوبة']);
    exit();
}

$name = trim($data['name']);
$email = trim($data['email']);
$message = trim($data['message']);
$type = isset($data['type']) ? trim($data['type']) : 'contact';

// Validate email
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['error' => 'البريد الإلكتروني غير صحيح']);
    exit();
}

// Create submission data
$submission = [
    'id' => uniqid(),
    'type' => $type,
    'name' => $name,
    'email' => $email,
    'message' => $message,
    'timestamp' => date('Y-m-d H:i:s'),
    'ip' => $_SERVER['REMOTE_ADDR'] ?? 'unknown'
];

// Add additional fields for investigation requests
if ($type === 'investigation' && isset($data['additional_fields'])) {
    $submission['additional_fields'] = $data['additional_fields'];
}

// File path for submissions
$submissions_file = 'submissions.json';

// Read existing submissions
$submissions = [];
if (file_exists($submissions_file)) {
    $existing_data = file_get_contents($submissions_file);
    $submissions = json_decode($existing_data, true) ?: [];
}

// Add new submission
$submissions[] = $submission;

// Save to file
$json_data = json_encode($submissions, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
if (file_put_contents($submissions_file, $json_data) === false) {
    http_response_code(500);
    echo json_encode(['error' => 'حدث خطأ في حفظ البيانات']);
    exit();
}

// Also save to a backup text file for easy reading
$text_entry = sprintf(
    "=== طلب جديد ===\nالنوع: %s\nالتاريخ: %s\nالاسم: %s\nالبريد الإلكتروني: %s\nالرسالة: %s\nعنوان IP: %s\n\n",
    $type === 'investigation' ? 'طلب تحقيق' : 'رسالة اتصال',
    $submission['timestamp'],
    $name,
    $email,
    $message,
    $submission['ip']
);

file_put_contents('submissions.txt', $text_entry, FILE_APPEND | LOCK_EX);

// Return success response
echo json_encode([
    'success' => true,
    'message' => 'تم إرسال الطلب بنجاح! سنتواصل معك قريباً.',
    'id' => $submission['id']
]);
?>

