<?php

// config/admin-sidebar.php
return [
    'main_menu' => [
        'dashboard' => [
            'type' => 'item',
            'label' => 'dashboard',
            'route' => 'admin.dashboard',
            'icon' => 'heroicon-o-squares-2x2',
            'permission' => null,
            'order' => 1,
            'active_routes' => ['admin.dashboard'],
            'badge' => null,
            'external' => false,
        ],

        'tenant_management' => [
            'type' => 'section',
            'label' => 'tenant',
            'icon' => 'heroicon-o-building-office-2',
            'permission' => 'admin.tenants.view',
            'order' => 2,
            'collapsed' => false,
            'default_expanded' => true,
            'section_id' => 'tenant',
            'children' => [
                'tenants_list' => [
                    'type' => 'item',
                    'label' => 'tenants',
                    'route' => 'admin.tenants.list',
                    'icon' => null,
                    'permission' => 'admin.tenants.view',
                    'order' => 1,
                    'active_routes' => ['admin.tenants.*'],
                    'badge_callback' => 'get_new_tenants_count',
                ],
            ],
        ],

        'support_management' => [
            'type' => 'section',
            'label' => 'support',
            'icon' => 'heroicon-o-ticket',
            'permission' => null,
            'order' => 5,
            'collapsed' => false,
            'default_expanded' => true,
            'section_id' => 'support',
            'children' => [
                'tickets' => [
                    'type' => 'item',
                    'label' => 'tickets',
                    'route' => 'admin.tickets.index',
                    'icon' => null,
                    'permission' => null,
                    'order' => 1,
                    'active_routes' => ['admin.tickets.*'],
                ],
            ],
        ],

        'whatsapp_management' => [
            'type' => 'section',
            'label' => 'whatsapp_webhook',
            'icon' => 'carbon-webhook',
            'permission' => null,
            'order' => 6,
            'collapsed' => false,
            'default_expanded' => true,
            'section_id' => 'whatsapp',
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isAdmin',
            'children' => [
                'whatsapp_webhook' => [
                    'type' => 'item',
                    'label' => 'whatsapp_webhook',
                    'route' => 'admin.whatsapp-webhook',
                    'icon' => null,
                    'permission' => null,
                    'order' => 1,
                    'active_routes' => ['admin.whatsapp-webhook'],
                ],
            ],
        ],

        'settings_management' => [
            'type' => 'section',
            'label' => 'settings',
            'icon' => 'heroicon-o-wrench-screwdriver',
            'permission' => ['admin.website_settings.view', 'admin.system_settings.view'],
            'permission_type' => 'any',
            'order' => 7,
            'collapsed' => false,
            'default_expanded' => true,
            'section_id' => 'settings',
            'children' => [
                'website_settings' => [
                    'type' => 'item',
                    'label' => 'website_settings',
                    'route' => 'admin.themes.settings.view',
                    'icon' => null,
                    'permission' => 'admin.website_settings.view',
                    'order' => 2,
                    'active_routes' => [
                        'admin.themes.settings.view',
                        'admin.section-title.settings.view',
                        'admin.hero-section.settings.view',
                        'admin.partner-logo.settings.view',
                        'admin.unique-feature.settings.view',
                        'admin.feature.settings.view',
                        'admin.testimonials.settings.view',
                        'admin.website-seo.settings.view',
                        'admin.custom-css.settings.view',
                        'admin.custom-js.settings.view',
                    ],
                ],
                'system_settings' => [
                    'type' => 'item',
                    'label' => 'system_settings',
                    'route' => 'admin.system.settings.view',
                    'icon' => null,
                    'permission' => 'admin.system_settings.view',
                    'order' => 3,
                    'active_routes' => [
                        'admin.system.settings.view',
                        'admin.email.settings.view',
                        'admin.re-captcha.settings.view',
                        'admin.cron-job.settings.view',
                        'admin.announcement.settings.view',
                        'admin.system-update.settings.view',
                        'admin.system-information.settings.view',
                        'admin.cache-management.settings.view',
                        'admin.advanced-optimization.settings.view',
                        'admin.tenant-settings.settings.view',
                        'admin.privacy-policy.settings.view',
                        'admin.terms-conditions.settings.view',
                        'admin.miscellaneous.settings.view',
                    ],
                ],
            ],
        ],
    ],

    // Setup menu configuration
    'setup_menu' => [
        'users' => [
            'type' => 'item',
            'label' => 'user',
            'route' => 'admin.users.list',
            'icon' => 'heroicon-o-users',
            'permission' => 'admin.users.view',
            'order' => 1,
            'active_routes' => ['admin.users.*'],
        ],
        'roles' => [
            'type' => 'item',
            'label' => 'role',
            'route' => 'admin.roles.list',
            'icon' => 'heroicon-o-swatch',
            'permission' => 'admin.roles.view',
            'order' => 2,
            'active_routes' => ['admin.roles.*'],
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isAdmin',
        ],
        'departments' => [
            'type' => 'item',
            'label' => 'department',
            'route' => 'admin.department.list',
            'icon' => 'heroicon-o-briefcase',
            'permission' => 'admin.department.view',
            'order' => 3,
            'active_routes' => ['admin.department.*'],
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isTicketsModuleEnabled',
        ],
        'languages' => [
            'type' => 'item',
            'label' => 'languages',
            'route' => 'admin.languages',
            'icon' => 'heroicon-s-language',
            'permission' => null,
            'order' => 4,
            'active_routes' => ['admin.languages'],
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isAdmin',
        ],
        'tenant_languages' => [
            'type' => 'item',
            'label' => 'tenant_languages',
            'route' => 'admin.tenant-languages',
            'icon' => 'heroicon-o-globe-alt',
            'permission' => null,
            'order' => 5,
            'active_routes' => ['admin.tenant-languages*'],
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isAdmin',
        ],
        'theme' => [
            'type' => 'item',
            'label' => 'theme',
            'route' => 'admin.theme',
            'icon' => 'heroicon-o-paint-brush',
            'permission' => null,
            'order' => 5,
            'active_routes' => ['admin.theme'],
        ],
        'faqs' => [
            'type' => 'item',
            'label' => 'faq',
            'route' => 'admin.faqs',
            'icon' => 'carbon-question-answering',
            'permission' => 'admin.faq.view',
            'order' => 9,
            'active_routes' => ['admin.faqs'],
        ],
        'pages' => [
            'type' => 'item',
            'label' => 'pages_sidebar',
            'route' => 'admin.pages',
            'icon' => 'carbon-white-paper',
            'permission' => 'admin.pages.view',
            'order' => 10,
            'active_routes' => ['admin.pages'],
        ],
        'email_templates' => [
            'type' => 'item',
            'label' => 'email_templates',
            'route' => 'admin.email-template.list',
            'icon' => 'heroicon-o-envelope',
            'permission' => 'admin.email_template.view',
            'order' => 11,
            'active_routes' => ['admin.email-template.*'],
        ],
        'system_logs' => [
            'type' => 'item',
            'label' => 'system_logs',
            'route' => 'admin.logs.index',
            'icon' => 'heroicon-o-document-text',
            'permission' => null,
            'order' => 12,
            'active_routes' => ['admin.logs.*'],
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::canViewLogs',
        ],
        'modules' => [
            'type' => 'item',
            'label' => 'modules',
            'route' => 'admin.modules.index',
            'icon' => 'heroicon-o-puzzle-piece',
            'permission' => null,
            'order' => 13,
            'active_routes' => ['admin.modules.*'],
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isAdmin',
        ],
    ],
];
